/*
  Copyright 2020 Equinor ASA.

  This file is part of the Open Porous Media project (OPM).

  OPM is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 3 of the License, or
  (at your option) any later version.

  OPM is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with OPM.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef AICD_HPP_HEADER_INCLUDED
#define AICD_HPP_HEADER_INCLUDED

#include <opm/input/eclipse/Schedule/MSW/SICD.hpp>

#include <map>
#include <string>
#include <utility>
#include <vector>

namespace Opm {

    class DeckRecord;
    class DeckKeyword;

} // namespace Opm

namespace Opm { namespace RestartIO {
    struct RstSegment;
}} // namespace Opm::RestartIO

namespace Opm {

    class AutoICD : public SICD
    {
    public:
        AutoICD() = default;
        explicit AutoICD(const DeckRecord& record);
        explicit AutoICD(const RestartIO::RstSegment& rstSegment);

        static AutoICD serializationTestObject();

        // the function will return a map
        // [
        //     "WELL1" : [<seg1, aicd1>, <seg2, aicd2> ...]
        //     ....
        static std::map<std::string, std::vector<std::pair<int, AutoICD>>>
        fromWSEGAICD(const DeckKeyword& wsegaicd);

        bool operator==(const AutoICD& data) const;

        template<class Serializer>
        void serializeOp(Serializer& serializer)
        {
            this->SICD::serializeOp(serializer);
            serializer(m_flow_rate_exponent);
            serializer(m_visc_exponent);
            serializer(m_oil_density_exponent);
            serializer(m_water_density_exponent);
            serializer(m_gas_density_exponent);
            serializer(m_oil_viscosity_exponent);
            serializer(m_water_viscosity_exponent);
            serializer(m_gas_viscosity_exponent);
        }

        double flowRateExponent() const;
        double viscExponent() const;
        double oilDensityExponent() const;
        double waterDensityExponent() const;
        double gasDensityExponent() const;
        double oilViscExponent() const;
        double waterViscExponent() const;
        double gasViscExponent() const;

    private:
        double m_flow_rate_exponent {};
        double m_visc_exponent {};
        double m_oil_density_exponent {};
        double m_water_density_exponent {};
        double m_gas_density_exponent {};
        double m_oil_viscosity_exponent {};
        double m_water_viscosity_exponent {};
        double m_gas_viscosity_exponent {};
    };
} // namespace Opm

#endif // AICD_HPP_HEADER_INCLUDED
