[![Travis-CI Build Status](https://travis-ci.org/ocaml/oasis.svg?branch=master)](https://travis-ci.org/ocaml/oasis)
[![AppVeyor Build status](https://ci.appveyor.com/api/projects/status/42gumiqt5le643t2?svg=true)](https://ci.appveyor.com/project/gildor478/oasis)
[![Join the chat at https://gitter.im/ocaml/oasis](https://badges.gitter.im/ocaml/oasis.svg)](https://gitter.im/ocaml/oasis?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge)

<!--- OASIS_START --->
<!--- DO NOT EDIT (digest: fa5b2e44255b14951d927b0e054fa38f) --->

oasis - Tooling for building OCaml libraries and applications
=============================================================

OASIS generates a full configure, build and install system for your
application. It starts with a simple `_oasis` file at the toplevel of your
project and creates everything required.

OASIS leverages existing OCaml tooling to perform most of it's work. In fact,
it might be more appropriate to think of it as simply the glue that binds
these other subsystems together and coordinates the work that they do. It
should support the following tools:

 * OCamlbuild
 * OMake
 * OCamlMakefile (todo),
 * ocaml-autoconf (todo)

It also features a do-it-yourself command line invocation and an internal
configure/install scheme. Libraries are managed through findlib. It has been
tested on GNU Linux and Windows.

It also allows to have standard entry points and description. It helps to
integrates your libraries and software with third parties tools like OPAM.

See the file [INSTALL.md](INSTALL.md) for building and installation
instructions.

[Home page](http://oasis.forge.ocamlcore.org/)

[Bug reports](https://github.com/ocaml/oasis/issues)

Copyright and license
---------------------

(C) 2011-2016 Sylvain Le Gall
(C) 2008-2010 OCamlCore SARL

oasis is distributed under the terms of the GNU Lesser General Public License
version 2.1 with OCaml linking exception.

See [COPYING.txt](COPYING.txt) for more information.

<!--- OASIS_STOP --->

Related documentation
---------------------

[OMake README](src/plugins/omake/README.md)

OPAM pin
--------

There is no `opam` directory in the master branch of this repository. All the
OPAM files are autogenerated and tested by automatic processes in different
branches.

To pin this repository with testing OPAM (recommended):
```
$> opam pin add oasis git://github.com/ocaml/oasis.git#opam/testing
```

To pin this repository with unstable OPAM (__not recommended__):
```
$> opam pin add oasis git://github.com/ocaml/oasis.git#opam/unstable
```

To generate an opam/ directory and pin your own local version:
```
$> cd inside_the_top_source_dir
$> make opam
$> opam pin add oasis .
```
