/* No repeated inclusion header here, as this
 * file is included several times. */

/* The following table, was built to encode the information in:
 *    https://www.w3.org/TR/REC-html40/index/elements.html
 */
HTML_TAG(a,		body,	_NONE,	_NONE,	0),
HTML_TAG(abbr,		body,	_NONE,	_NONE,	0),
HTML_TAG(acronym,	body,	_NONE,	_NONE,	0),
HTML_TAG(address,	body,	_NONE,	_NONE,	0),
HTML_TAG(applet,	body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(area,		map,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(b,		body,	_NONE,	_NONE,	0),
HTML_TAG(base,		head,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(basefont,	body,	_NONE,	_NONE,	END_FORBIDDEN | DEPRECATED | DTD_LOOSE),
HTML_TAG(bdo,		html,	_NONE,	_NONE,	0),
HTML_TAG(big,		body,	_NONE,	_NONE,	0),
HTML_TAG(blockquote,	body,	_NONE,	_NONE,	0),
HTML_TAG(body,		html,	_NONE,	_NONE,	START_OPTIONAL | END_OPTIONAL),
HTML_TAG(br,		body,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(button,	body,	_NONE,	_NONE,	0),
HTML_TAG(caption,	body,	_NONE,	_NONE,	0),
HTML_TAG(center,	body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(cite,		body,	_NONE,	_NONE,	0),
HTML_TAG(code,		body,	_NONE,	_NONE,	0),
HTML_TAG(col,		table,	_NONE,	_NONE,	END_FORBIDDEN | (3<<TABLE_SHIFT)),
HTML_TAG(colgroup,	table,	_NONE,	_NONE,	END_OPTIONAL | (2<<TABLE_SHIFT)),
HTML_TAG(dd,		dl,	_NONE,	_NONE,	END_OPTIONAL),
HTML_TAG(del,		body,	_NONE,	_NONE,	0),
HTML_TAG(dfn,		body,	_NONE,	_NONE,	0),
HTML_TAG(dir,		body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(div,		body,	_NONE,	_NONE,	CONTAINER),
HTML_TAG(dl,		body,	_NONE,	_NONE,	CONTAINER),
HTML_TAG(dt,		dl,	_NONE,	_NONE,	0),
HTML_TAG(em,		body,	_NONE,	_NONE,	0),
HTML_TAG(fictionbook,	_NONE,	_NONE,	_NONE,	0),
HTML_TAG(fieldset,	form,	_NONE,	_NONE,	0),
HTML_TAG(font,		body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(form,		body,	_NONE,	_NONE,	0),
HTML_TAG(frame,		frameset,_NONE,	_NONE,	END_FORBIDDEN | DTD_FRAMESET),
HTML_TAG(frameset,	body,	_NONE,	_NONE,	DTD_FRAMESET),
HTML_TAG(h1,		body,	_NONE,	_NONE,	0),
HTML_TAG(h2,		body,	_NONE,	_NONE,	0),
HTML_TAG(h3,		body,	_NONE,	_NONE,	0),
HTML_TAG(h4,		body,	_NONE,	_NONE,	0),
HTML_TAG(h5,		body,	_NONE,	_NONE,	0),
HTML_TAG(h6,		body,	_NONE,	_NONE,	0),
HTML_TAG(head,		html,	_NONE,	_NONE,	START_OPTIONAL | END_OPTIONAL),
HTML_TAG(hr,		body,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(html,		_NONE,	_NONE,	_NONE,	START_OPTIONAL | END_OPTIONAL),
HTML_TAG(i,		body,	_NONE,	_NONE,	0),
HTML_TAG(iframe,	html,	_NONE,	_NONE,	DTD_LOOSE),
HTML_TAG(img,		body,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(input,		body,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(ins,		body,	_NONE,	_NONE,	0),
HTML_TAG(isindex,	head,	_NONE,	_NONE,	END_FORBIDDEN | DEPRECATED | DTD_LOOSE),
HTML_TAG(kbd,		body,	_NONE,	_NONE,	0),
HTML_TAG(label,		body,	_NONE,	_NONE,	0),
HTML_TAG(legend,	body,	_NONE,	_NONE,	0),
HTML_TAG(li,		ul,	ol,	menu,	END_OPTIONAL),
HTML_TAG(link,		html,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(map,		body,	_NONE,	_NONE,	0),
HTML_TAG(menu,		body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(meta,		head,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(noframes,	frameset,_NONE,	_NONE,	DTD_FRAMESET),
HTML_TAG(noscript,	html,	_NONE,	_NONE,	0),
HTML_TAG(object,	body,	_NONE,	_NONE,	0),
HTML_TAG(ol,		body,	_NONE,	_NONE,	CONTAINER),
HTML_TAG(optgroup,	select,	_NONE,	_NONE,	0),
HTML_TAG(option,	select,	_NONE,	_NONE,	END_OPTIONAL),
HTML_TAG(p,		body,	_NONE,	_NONE,	END_OPTIONAL),
HTML_TAG(param,		object,	_NONE,	_NONE,	END_FORBIDDEN),
HTML_TAG(pre,		body,	_NONE,	_NONE,	0),
HTML_TAG(q,		body,	_NONE,	_NONE,	0),
HTML_TAG(s,		body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(samp,		body,	_NONE,	_NONE,	0),
HTML_TAG(script,	html,	_NONE,	_NONE,	0),
HTML_TAG(select,	body,	_NONE,	_NONE,	0),
HTML_TAG(small,		body,	_NONE,	_NONE,	0),
HTML_TAG(span,		body,	_NONE,	_NONE,	CONTAINER),
HTML_TAG(strike,	body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(strong,	body,	_NONE,	_NONE,	0),
HTML_TAG(style,		html,	_NONE,	_NONE,	0),
HTML_TAG(sub,		body,	_NONE,	_NONE,	0),
HTML_TAG(sup,		body,	_NONE,	_NONE,	0),
HTML_TAG(table,		body,	_NONE,	_NONE,	CONTAINER | (1<<TABLE_SHIFT)),
HTML_TAG(tbody,		table,	_NONE,	_NONE,	START_OPTIONAL | END_OPTIONAL | (4<<TABLE_SHIFT)),
HTML_TAG(td,		tr,	_NONE,	_NONE,	END_OPTIONAL | (6<<TABLE_SHIFT)),
HTML_TAG(textarea,	body,	_NONE,	_NONE,	0),
HTML_TAG(tfoot,		table,	_NONE,	_NONE,	END_OPTIONAL | (4<<TABLE_SHIFT)),
HTML_TAG(th,		tr,	_NONE,	_NONE,	END_OPTIONAL | (6<<TABLE_SHIFT)),
HTML_TAG(thead,		table,	_NONE,	_NONE,	END_OPTIONAL | (4<<TABLE_SHIFT)),
HTML_TAG(title,		head,	_NONE,	_NONE,	0),
HTML_TAG(tr,		table,	_NONE,	_NONE,	END_OPTIONAL | (5<<TABLE_SHIFT)),
HTML_TAG(tt,		body,	_NONE,	_NONE,	0),
HTML_TAG(u,		body,	_NONE,	_NONE,	DEPRECATED | DTD_LOOSE),
HTML_TAG(ul,		body,	_NONE,	_NONE,	CONTAINER),
HTML_TAG(var,		body,	_NONE,	_NONE,	0)

#undef HTML_TAG
