# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_object_algorithm import DataObjectAlgorithm


class XdmfWriter(DataObjectAlgorithm):
    r"""
    XdmfWriter - write eXtensible Data Model and Format files
    
    Superclass: DataObjectAlgorithm
    
    XdmfWriter converts DataObjects to XDMF format. This is
    intended to replace XdmfWriter, which is not up to date with the
    capabilities of the newer XDMF2 library. This writer understands
    VTK's composite data types and produces full trees in the output XDMF
    files.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkXdmfWriter, obj, update, **traits)
    
    mesh_static_over_time = tvtk_base.false_bool_trait(desc=\
        r"""
        Set of get the flag that specify if input mesh is static over
        time. If so, the mesh topology and geometry heavy data will be
        written only once. Default if FALSE. Note: this mode requires
        that all data is dumped in the heavy data file.
        """
    )

    def _mesh_static_over_time_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetMeshStaticOverTime,
                        self.mesh_static_over_time_)

    write_all_time_steps = tvtk_base.false_bool_trait(desc=\
        r"""
        Controls whether writer automatically writes all input time
        steps, or just the timestep that is currently on the input.
        Default is OFF.
        """
    )

    def _write_all_time_steps_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetWriteAllTimeSteps,
                        self.write_all_time_steps_)

    file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Set or get the file name of the xdmf file.
        """
    )

    def _file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetFileName,
                        self.file_name)

    heavy_data_file_name = tvtk_base.vtk_file_name("", desc=\
        r"""
        Set or get the file name of the hdf5 file. Note that if the File
        name is not specified, then the group name is ignore
        """
    )

    def _heavy_data_file_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHeavyDataFileName,
                        self.heavy_data_file_name)

    heavy_data_group_name = traits.Trait(None, None, traits.String(enter_set=True, auto_set=False), desc=\
        r"""
        Set or get the group name into which data will be written it may
        contain nested groups as in "/Proc0/Block0"
        """
    )

    def _heavy_data_group_name_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetHeavyDataGroupName,
                        self.heavy_data_group_name)

    light_data_limit = traits.Int(100, enter_set=True, auto_set=False, desc=\
        r"""
        Topology Geometry and Attribute arrays smaller than this are
        written in line into the XML. Default is 100. Node:
        light_data_limit is forced to 1 when mesh_static_over_time is TRUE.
        """
    )

    def _light_data_limit_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetLightDataLimit,
                        self.light_data_limit)

    def _get_input(self):
        try:
            return wrap_vtk(self._vtk_obj.GetInput(0))
        except TypeError:
            return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input,
                            desc="The first input of this object, i.e. the result of `get_input(0)`.")
    
    def get_input(self, *args):
        """
        get_input(self) -> DataObject
        C++: DataObject *get_input()
        get_input(self, port:int) -> DataObject
        C++: DataObject *get_input(int port)"""
        ret = self._wrap_call(self._vtk_obj.GetInput, *args)
        return wrap_vtk(ret)

    def set_number_of_pieces(self, *args):
        """
        set_number_of_pieces(self, _arg:int) -> None
        C++: virtual void set_number_of_pieces(int _arg)"""
        ret = self._wrap_call(self._vtk_obj.SetNumberOfPieces, *args)
        return ret

    def set_piece(self, *args):
        """
        set_piece(self, _arg:int) -> None
        C++: virtual void set_piece(int _arg)
        Called in parallel runs to identify the portion this process is
        responsible for TODO: respect this
        """
        ret = self._wrap_call(self._vtk_obj.SetPiece, *args)
        return ret

    def write(self):
        """
        write(self) -> int
        C++: virtual int write()
        Write data to output. Method executes subclasses write_data()
        method, as well as start_method() and end_method() methods. Returns
        1 on success and 0 on failure.
        """
        ret = self._vtk_obj.Write()
        return ret
        

    _updateable_traits_ = \
    (('mesh_static_over_time', 'GetMeshStaticOverTime'),
    ('write_all_time_steps', 'GetWriteAllTimeSteps'), ('abort_execute',
    'GetAbortExecute'), ('release_data_flag', 'GetReleaseDataFlag'),
    ('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('file_name', 'GetFileName'),
    ('heavy_data_file_name', 'GetHeavyDataFileName'),
    ('heavy_data_group_name', 'GetHeavyDataGroupName'),
    ('light_data_limit', 'GetLightDataLimit'), ('progress',
    'GetProgress'), ('progress_text', 'GetProgressText'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'mesh_static_over_time', 'release_data_flag', 'write_all_time_steps',
    'file_name', 'heavy_data_file_name', 'heavy_data_group_name',
    'light_data_limit', 'progress_text'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(XdmfWriter, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit XdmfWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['mesh_static_over_time', 'write_all_time_steps'], [],
            ['file_name', 'heavy_data_file_name', 'heavy_data_group_name',
            'light_data_limit']),
            title='Edit XdmfWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit XdmfWriter properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

