-- Copyright 2004-2019 H2 Group. Multiple-Licensed under the MPL 2.0,
-- and the EPL 1.0 (http://h2database.com/html/license.html).
-- Initial Developer: H2 Group
--

CREATE TABLE TEST(G GEOMETRY, G_S GEOMETRY(GEOMETRY, 1), P GEOMETRY(POINT), P_S GEOMETRY(POINT, 1),
    PZ1 GEOMETRY(POINT Z), PZ2 GEOMETRY(POINTZ), PZ1_S GEOMETRY(POINT Z, 1), PZ2_S GEOMETRY(POINTZ, 1),
    PM GEOMETRY(POINT M), PZM GEOMETRY(POINT ZM), PZM_S GEOMETRY(POINT ZM, -100),
    LS GEOMETRY(LINESTRING), PG GEOMETRY(POLYGON),
    MP GEOMETRY(MULTIPOINT), MLS GEOMETRY(MULTILINESTRING), MPG GEOMETRY(MULTIPOLYGON),
    GC GEOMETRY(GEOMETRYCOLLECTION));
> ok

INSERT INTO TEST VALUES ('POINT EMPTY', 'SRID=1;POINT EMPTY', 'POINT EMPTY', 'SRID=1;POINT EMPTY',
    'POINT Z EMPTY', 'POINT Z EMPTY', 'SRID=1;POINT Z EMPTY', 'SRID=1;POINTZ EMPTY',
    'POINT M EMPTY', 'POINT ZM EMPTY', 'SRID=-100;POINT ZM EMPTY',
    'LINESTRING EMPTY', 'POLYGON EMPTY',
    'MULTIPOINT EMPTY', 'MULTILINESTRING EMPTY', 'MULTIPOLYGON EMPTY',
    'GEOMETRYCOLLECTION EMPTY');
> update count: 1

SELECT COLUMN_NAME, TYPE_NAME, COLUMN_TYPE FROM INFORMATION_SCHEMA.COLUMNS
    WHERE TABLE_NAME = 'TEST' ORDER BY ORDINAL_POSITION;
> COLUMN_NAME TYPE_NAME COLUMN_TYPE
> ----------- --------- ----------------------------
> G           GEOMETRY  GEOMETRY
> G_S         GEOMETRY  GEOMETRY(GEOMETRY, 1)
> P           GEOMETRY  GEOMETRY(POINT)
> P_S         GEOMETRY  GEOMETRY(POINT, 1)
> PZ1         GEOMETRY  GEOMETRY(POINT Z)
> PZ2         GEOMETRY  GEOMETRY(POINT Z)
> PZ1_S       GEOMETRY  GEOMETRY(POINT Z, 1)
> PZ2_S       GEOMETRY  GEOMETRY(POINT Z, 1)
> PM          GEOMETRY  GEOMETRY(POINT M)
> PZM         GEOMETRY  GEOMETRY(POINT ZM)
> PZM_S       GEOMETRY  GEOMETRY(POINT ZM, -100)
> LS          GEOMETRY  GEOMETRY(LINESTRING)
> PG          GEOMETRY  GEOMETRY(POLYGON)
> MP          GEOMETRY  GEOMETRY(MULTIPOINT)
> MLS         GEOMETRY  GEOMETRY(MULTILINESTRING)
> MPG         GEOMETRY  GEOMETRY(MULTIPOLYGON)
> GC          GEOMETRY  GEOMETRY(GEOMETRYCOLLECTION)
> rows (ordered): 17

UPDATE TEST SET G = 'SRID=10;LINESTRING EMPTY';
> update count: 1

UPDATE TEST SET GC = 'SRID=8;GEOMETRYCOLLECTION(POINT (1 1))';
> update count: 1

UPDATE TEST SET G_S = 'POINT (1 1)';
> exception CHECK_CONSTRAINT_VIOLATED_1

UPDATE TEST SET P = 'POINT Z EMPTY';
> exception CHECK_CONSTRAINT_VIOLATED_1

UPDATE TEST SET P = 'POLYGON EMPTY';
> exception CHECK_CONSTRAINT_VIOLATED_1

UPDATE TEST SET PZ1 = 'POINT EMPTY';
> exception CHECK_CONSTRAINT_VIOLATED_1

SELECT * FROM TEST;
> G                        G_S                P           P_S                PZ1           PZ2           PZ1_S                PZ2_S                PM            PZM            PZM_S                    LS               PG            MP               MLS                   MPG                GC
> ------------------------ ------------------ ----------- ------------------ ------------- ------------- -------------------- -------------------- ------------- -------------- ------------------------ ---------------- ------------- ---------------- --------------------- ------------------ ---------------------------------------
> SRID=10;LINESTRING EMPTY SRID=1;POINT EMPTY POINT EMPTY SRID=1;POINT EMPTY POINT Z EMPTY POINT Z EMPTY SRID=1;POINT Z EMPTY SRID=1;POINT Z EMPTY POINT M EMPTY POINT ZM EMPTY SRID=-100;POINT ZM EMPTY LINESTRING EMPTY POLYGON EMPTY MULTIPOINT EMPTY MULTILINESTRING EMPTY MULTIPOLYGON EMPTY SRID=8;GEOMETRYCOLLECTION (POINT (1 1))
> rows: 1

SELECT G FROM TEST WHERE P_S = 'SRID=1;POINT EMPTY';
>> SRID=10;LINESTRING EMPTY

SELECT G FROM TEST WHERE P_S = 'GEOMETRYCOLLECTION Z EMPTY';
> exception CHECK_CONSTRAINT_VIOLATED_1

CREATE SPATIAL INDEX IDX ON TEST(GC);
> ok

SELECT P FROM TEST WHERE GC = 'SRID=8;GEOMETRYCOLLECTION (POINT (1 1))';
>> POINT EMPTY

SELECT P FROM TEST WHERE GC = 'SRID=8;GEOMETRYCOLLECTION Z (POINT (1 1 1))';
> exception CHECK_CONSTRAINT_VIOLATED_1

SELECT CAST('POINT EMPTY' AS GEOMETRY(POINT));
>> POINT EMPTY

SELECT CAST('POINT EMPTY' AS GEOMETRY(POINT Z));
> exception CHECK_CONSTRAINT_VIOLATED_1

SELECT CAST('POINT EMPTY' AS GEOMETRY(POINT, 0));
>> POINT EMPTY

SELECT CAST('POINT EMPTY' AS GEOMETRY(POINT, 1));
> exception CHECK_CONSTRAINT_VIOLATED_1

SELECT CAST('POINT EMPTY' AS GEOMETRY(POLYGON));
> exception CHECK_CONSTRAINT_VIOLATED_1

DROP TABLE TEST;
> ok
