import "../color/lab";

d3.interpolateLab = d3_interpolateLab;

function d3_interpolateLab(a, b) {
  a = d3.lab(a);
  b = d3.lab(b);
  var al = a.l,
      aa = a.a,
      ab = a.b,
      bl = b.l - al,
      ba = b.a - aa,
      bb = b.b - ab;
  return function(t) {
    return d3_lab_rgb(al + bl * t, aa + ba * t, ab + bb * t) + "";
  };
}
